/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.tectech.helper.StructureDefinitions;
import com.github.technus.tectech.mechanics.constructable.IConstructable;
import com.github.technus.tectech.mechanics.structure.IStructureDefinition;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.StructureDefinition;
import com.github.technus.tectech.mechanics.structure.StructureUtility;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class TT_VaccuumFreezer
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static final byte TEXTURE_INDEX = 17;
    private byte blocks = 0;
    private static final IStructureDefinition<TT_VaccuumFreezer> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureDefinitions.CUBE_NO_MUFFLER.getDefinition()).addElement(Character.valueOf('V'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofHatchAdder(TT_VaccuumFreezer::addVaccumFreezerHatches, (int)17, (int)1), StructureUtility.onElementPass(x -> {
        x.blocks = (byte)(x.blocks + 1);
    }, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)1))})).build();

    public TT_VaccuumFreezer(Object unused) {
        super(32765, "multimachine.vacuumfreezer", "Vacuum Freezer");
        GregTech_API.METATILEENTITIES[32765] = null;
        GregTech_API.METATILEENTITIES[1002] = this;
    }

    protected boolean cyclicUpdate_EM() {
        return false;
    }

    private TT_VaccuumFreezer(String aName) {
        super(aName);
    }

    public IStructureDefinition<TT_VaccuumFreezer> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public String[] getDescription() {
        return new String[]{"Controller Block for the Vacuum Freezer", "Super cools hot ingots and cells", "Size(WxHxD): 3x3x3 (Hollow), Controller (Front centered)", "1x Input Bus (Any casing)", "1x Output Bus (Any casing)", "1x Maintenance Hatch (Any casing)", "1x Energy Hatch (Any casing)", "Frost Proof Machine Casings for the rest (16 at least!)", BW_Tooltip_Reference.ADV_STR_CHECK};
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.blocks = 0;
        return this.structureCheck_EM("main", 1, 1, 0) && this.blocks >= 16;
    }

    @SideOnly(value=Side.CLIENT)
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17]};
    }

    public boolean checkRecipe_EM(ItemStack itemStack) {
        ArrayList tInputList = this.getStoredInputs();
        for (ItemStack tInput : tInputList) {
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sVacuumRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], null, new ItemStack[]{tInput});
            if (tRecipe == null || !tRecipe.isRecipeInputEqual(true, null, new ItemStack[]{tInput})) continue;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0)};
            this.updateSlots();
            return true;
        }
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new TT_VaccuumFreezer(this.mName);
    }

    public boolean isMachineBlockUpdateRecursive() {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM("main", 1, 1, 0, b, itemStack);
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return new String[0];
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "VacuumFreezer.png");
    }

    public final boolean addVaccumFreezerHatches(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity != null) {
            IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
            if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch)) {
                return false;
            }
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
                return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
                return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
                return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
                return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
                return this.eEnergyMulti.add((GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity);
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
                return this.eDynamoMulti.add((GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity);
            }
        }
        return false;
    }
}

